
-------------------------------------------------
-- WEAPON ZONES 0.3
-- by mikade
-------------------------------------------------

-- VERSION HISTORY/NOTES
-----------------------------
--0.1
-----------------------------
-- adapted blox map to suit this mode
-- added some zones
-- added circle in-a-zone-indicator (and improved it to have 3 states)
-- added basic input masking whilst in a zone (and added checking for wep)
-- added exceptions to input mask so that you can't drop bombs from UFO but can drop eggs from birdy (hopefully)
-- added map description
-- experimented with autoselect/weapon correction using setweap. had some issues at first, but added lots of checking between currently selected weapon and specialGear, to pretty much make it work pR0 (hopefully, again)
-- for zones that are mouse controlled, autoselect is disabled.
-- the player can now skip his go under any circumstances YAY

-----------------------------
--0.2
-----------------------------
-- added WriteLnToConsole entries to debug desyncs
-- TurnTime reduced to 30s

-----------------------------
--0.3
-----------------------------
-- added CurWeapon and LastWeapon to help optimize performance a little, should be useful in other ways, too
-- fixed a bug with the visual gears that I couldn't see on the other monitor >_<
-- now no longer possible to cheat the inputmask with inhuman reflexes
-- implemented autochange to empty hands when not on a weapon platform
-- solved all airstrike / mouse-related weapon concerns, I think
-- renamed mission to "Weapon Zones"

-- added future support for amBee, amMineStrike, amGirder, amNapalm and amTardis

-- added 2 ballgun posts (2 to prevent griefing in the house)
-- added RC Plane post to balance Lcloud vulnerability
-- added ballgun post to balance Ltower vulnerability
-- added melon post to balance Rcloud vulnerability
-- added cake post to balance Rtower vulnerability

-- teleport is now limited to 3 uses
-- changed dynamite post to shotgun
-- changed mine posts to dyanmite
-- changed cake post to UFO
-- changed UFO post to teleport

------------------
-- limits and
-- unresolved things that i'll need to account for / fix and
-- other ideas
-------------------

-- mode possibly causes desyncs

-- parachute triggers cant be used really as it would be off a block, it also opens automatically and is possibly unpreventable.

-- if you want to be able to destroy the terrain, then a mask on blocks will be needed, and a few zones might need to change

-- at the moment the maps spawns without barrels/mines. if these are desired they need to be checked and placed off the weapon zones
-- until sanity limit kicks in

loadfile(GetDataPath() .. "Scripts/Locale.lua")()

-------------
-- got vars?
-------------

local vCirc
local specialGear = nil

local curWeapon
local lastWeapon
--local changeCount = 0

function IsAMouseBasedWeapon(zeWeapon)

	if 	(zeWeapon == amAirAttack) or
		(zeWeapon == amNapalm) or
		(zeWeapon == amMineStrike) or
		(zeWeapon == amPiano) or
		(zeWeapon == amTeleport) or
		(zeWeapon == amBee) or
		(zeWeapon == amGirder) then
			return(true)
	else
			return(false)
	end

end

--------------------------------
--zone variables / methods
--------------------------------

local checkCounter = 0

local zXMin = {}
local zWidth = {}
local zYMin = {}
local zHeight = {}
local zWep = {}
local zOccupied = {}
local zCount = 0

function CreateZone(xMin, yMin, width, height, wep)

	zXMin[zCount] = xMin
	zYMin[zCount] = yMin
	zWidth[zCount] = width
	zHeight[zCount] = height
	zWep[zCount] = wep
	zOccupied[zCount] = false
	zCount = zCount + 1

	return (zCount-1)

end

function GearIsInZone(gear, zI)

	if (GetX(gear) > zXMin[zI]) and (GetX(gear) < (zXMin[zI]+zWidth[zI])) and (GetY(gear) > zYMin[zI]) and (GetY(gear) < (zYMin[zI]+zHeight[zI])) then
		zOccupied[zI] = true
	else
		zOccupied[zI] = false
	end

	return zOccupied[zI]

end

function CheckZones()

	WriteLnToConsole("Start of CheckZones ()")

	cycle = true

	g1, g2, g3, g4, g5, g6, g7, g8, g9, g10 = GetVisualGearValues(vCirc)
	SetVisualGearValues(vCirc, GetX(CurrentHedgehog), GetY(CurrentHedgehog), g3, g4, g5, g6, g7, 0, 0, 0xffffff00)

	-- IS IT TIME TO SET SOME INPUT MASKS BASED ON WHAT IS GOING ON??? I THINK IT IS.
	if specialGear == nil then

		WriteLnToConsole("No special gears are active.")

		if GetCurAmmoType() == amSkip then
			--okay FINE, you can skip your go, I GUESS.
			SetInputMask(0xFFFFFFFF)
			WriteLnToConsole("GetCurAmmoType returned amSkip at: " .. GameTime)
			WriteLnToConsole("Inputmask set (Clear) at: " .. GameTime)

		else
			-- no special cases, don't you dare fire
			SetInputMask(band(0xFFFFFFFF, bnot(gmAttack)))
			WriteLnToConsole("Inputmask set (Attack) at: " .. GameTime)
		end

	elseif (GetGearType(specialGear) == gtJetpack) or (GetGearType(specialGear) == gtRope) or (GetGearType(specialGear) == gtParachute) then
		-- okay, you can cancel your method of transport, but none of that "dropping bombs" funny business
		SetInputMask(band(0xFFFFFFFF, bnot(gmLJump)))
		WriteLnToConsole("SpecialGear active: UFO/Rope/Parachute")
		WriteLnToConsole("Inputmask (LJump) set at: " .. GameTime)
	elseif GetGearType(specialGear) == gtBirdy then
		-- Look out below.
		SetInputMask(0xFFFFFFFF)
		WriteLnToConsole("SpecialGear active: Birdy")
		WriteLnToConsole("Inputmask (Clear) set at: " .. GameTime)
	else
		-- did i miss something? better just shut you down in case...
		SetInputMask(band(0xFFFFFFFF, bnot(gmAttack)))
		WriteLnToConsole("SpecialGear active: Exception")
		WriteLnToConsole("Inputmask set (Attack) at: " .. GameTime)
	end

	--AddCaption('Outside of all battle zones. Y_Y')

	WriteLnToConsole("About to start checking the zones themselves...")
	for i = 0,(zCount-1) do

		if ((GearIsInZone(CurrentHedgehog,i)) == true) and (specialGear == nil) then -- last part is new, prevents firing from ufo/rope etc and autoselection of weapons when near them and using ufo/rope etc.

			--WriteLnToConsole("No special gears are active.")
			WriteLnToConsole("CurrentHedgehog is inside zone " .. i)

			cycle = false


			if GetCurAmmoType() == zWep[i] then

				SetInputMask(0xFFFFFFFF)
				SetVisualGearValues(vCirc, GetX(CurrentHedgehog), GetY(CurrentHedgehog), g3, g4, g5, g6, g7, 150, 3, GetClanColor(GetHogClan(CurrentHedgehog)))
				--AddCaption('In a zone, ready to fire.')
				WriteLnToConsole("GetCurAmmoType matched zone " .. i .." at: " .. GameTime)
				WriteLnToConsole("Inputmask set (Clear) at: " .. GameTime)
				WriteLnToConsole("We are clear to fire, go go go!")

			elseif GetCurAmmoType() ~= amSkip then

				WriteLnToConsole("GetCurAmmoType did not match zone " .. i .. " at " .. GameTime)

				SetVisualGearValues(vCirc, GetX(CurrentHedgehog), GetY(CurrentHedgehog), g3, g4, g5, g6, g7, 150, 3, 0xffffffff)
				--AddCaption('In a zone, but wrong weapon, Jack.')
				--if (zWep[i] == amAirAttack) or (zWep[i] == amTeleport) or (zWep[i] == amBee) then -- new
				if IsAMouseBasedWeapon(zWep[i]) then
				-- don't want to halt your movement there with mouse based interface suddenly, rather let the user manually select these weapons
					cycle = true
					WriteLnToConsole("Zone " .. i .. " is a mouse based weapon point")
				else
					-- go ahead and switch my weapons for me
					WriteLnToConsole("All clear to autoswitch weapon for player")
					ParseCommand("setweap " .. string.char(zWep[i]))	-- experimental add
					WriteLnToConsole("Issued ParseCommand setweap(weaponforthiszone) at " .. GameTime)
				end

			end

		end

	end

	if (cycle == true) and (GetCurAmmoType() ~= amNothing) then
		SetGearMessage(CurrentHedgehog, GetGearMessage(CurrentHedgehog) + gmSlot)
	end

	WriteLnToConsole("End of CheckZones ()")

end

------------------------
-- game methods
------------------------

function onGameInit()

	GameFlags = gfSolidLand
	TurnTime = 30000 --25000
	CaseFreq = 0
	MinesNum = 0
	MinesTime  = 3000
	Explosives = 0
	Delay = 10
	SuddenDeathTurns = 30 --9999

end

function onGameStart()

	ShowMission	(
				loc("WEAPON ZONES"),
				loc("a Hedgewars mini-game"),
				loc("Usage of weapons is restricted to their designated zones.") .. "|" ..
				"", 4, 0
				)


	vCirc = AddVisualGear(0,0,vgtCircle,0,true)
	SetVisualGearValues(vCirc, GetX(CurrentHedgehog),GetY(CurrentHedgehog), 20, 125, 1, 10, 0, 150, 3, 0xffffff00)

	--------------------
	-- WEAPON ZONES
	--------------------
	--LEFT TOWER
	CreateZone(1208,1607,118,25,amClusterBomb)
	CreateZone(1306,1698,75,25,amBazooka)
	CreateZone(1130,1688,75,50,amBallgun)

	--LEFT FLOOR
	CreateZone(1155,1949,75,50,amTeleport)
	CreateZone(1306,1951,75,50,amDrill)
	CreateZone(1455,1944,75,50,amAirAttack)
	CreateZone(1608,1912,75,50,amBazooka)
	CreateZone(1757,1909,75,50,amBirdy)

	-- LEFT CLOUD
	CreateZone(1503,1394,75,25,amDynamite)
	CreateZone(1847,1323,75,25,amMolotov)
	CreateZone(1789,1278,75,50,amRCPlane)

	-- LEFT HOUSE
	CreateZone(1703,1736,75,25,amFlamethrower)
	CreateZone(1739,1685,75,25,amGasBomb)
	CreateZone(1981,1764,75,25,amTeleport)
	CreateZone(1901,1769,75,50,amBallgun)
	CreateZone(2005,1427,75,25,amGrenade)
	CreateZone(2077,1353,119,25,amHellishBomb)

	-------------------------------------------------

	--RIGHT TOWER
	CreateZone(2777,1648,75,50,amSMine)
	CreateZone(2860,1563,114,50,amClusterBomb)
	CreateZone(2986,1644,75,50,amCake)

	--RIGHT FLOOR
	CreateZone(2581,1907,75,50,amAirAttack)
	CreateZone(2806,1916,75,50,amDrill)
	CreateZone(2957,1953,75,50,amJetpack)
	CreateZone(2452,1912,75,50,amRope)

	-- RIGHT CLOUD
	CreateZone(2110,1274,99,25,amShotgun)
	--CreateZone(2295,1152,118,25,amGrenade)
	CreateZone(2531,1279,75,25,amDynamite)
	CreateZone(2303,1151,112,50,amWatermelon)

	-- RIGHT HOUSE
	CreateZone(2201,1431,90,25,amGrenade)
	CreateZone(2451,1690,75,25,amGasBomb)
	CreateZone(2491,1727,75,25,amShotgun)
	CreateZone(2207,1764,75,25,amTeleport)
	CreateZone(2288,1769,75,50,amBallgun)


end

function onGameTick()

	if CurrentHedgehog ~= nil then

		curWeapon = GetCurAmmoType()

		if curWeapon ~= lastWeapon then
			--changeCount = changeCount + 1
			--AddCaption("Weapon changed, boss " .. changeCount)
			CheckZones()
		end

		g1, g2, g3, g4, g5, g6, g7, g8, g9, g10 = GetVisualGearValues(vCirc)
		SetVisualGearValues(vCirc, GetX(CurrentHedgehog), GetY(CurrentHedgehog), g3, g4, g5, g6, g7, g8, g9, g10)

		checkCounter = checkCounter + 1
		if checkCounter == 100 then	--100
			checkCounter = 0
			CheckZones()
		end

		lastWeapon = curWeapon

	end
end


function onAmmoStoreInit()

	SetAmmo(amBazooka, 9, 0, 0, 0)
	SetAmmo(amDrill, 9, 0, 0, 0)

	SetAmmo(amGrenade, 9, 0, 0, 0)
	SetAmmo(amClusterBomb, 9, 0, 0, 0)
	SetAmmo(amHellishBomb, 9, 0, 0, 0)
	SetAmmo(amGasBomb, 9, 0, 0, 0)
	SetAmmo(amMolotov, 9, 0, 0, 0)
	SetAmmo(amWatermelon, 9, 0, 0, 0)

	SetAmmo(amFlamethrower, 9, 0, 0, 0)
	SetAmmo(amShotgun, 9, 0, 0, 0)

	SetAmmo(amBallgun, 9, 0, 0, 0)

	SetAmmo(amMine, 9, 0, 0, 0)
	SetAmmo(amSMine, 9, 0, 0, 0)
	SetAmmo(amDynamite, 9, 0, 0, 0)
	SetAmmo(amCake, 9, 0, 0, 0)
	SetAmmo(amRCPlane, 9, 0, 0, 0)

	SetAmmo(amAirAttack, 9, 0, 0, 0)

	--SetAmmo(amBlowTorch, 9, 0, 0, 0)

	SetAmmo(amRope, 9, 0, 0, 0)
	--SetAmmo(amParachute, 9, 0, 0, 0)

	SetAmmo(amJetpack, 9, 0, 0, 0)
	SetAmmo(amBirdy, 9, 0, 0, 0)
	SetAmmo(amTeleport, 3, 0, 0, 0) -----------

	--SetAmmo(amSwitch, 9, 0, 0, 0)
	SetAmmo(amSkip, 9, 0, 0, 0)

end

function onGearAdd(gear)
	if (GetGearType(gear) == gtBirdy) or (GetGearType(gear) == gtJetpack) or (GetGearType(gear) == gtRope) or (GetGearType(gear) == gtParachute) then
		specialGear = gear

		if GetGearType(gear) == gtBirdy then
			AddCaption(loc("Nice legs!"))
		elseif GetGearType(gear) == gtJetpack then
			AddCaption(loc("See you in space, cowboy."))
		elseif GetGearType(gear) == gtRope then
			AddCaption(loc("Yo, I'm a ninja!"))
		elseif GetGearType(gear) == gtParachute then
			AddCaption(loc("Look at me! I can fly! Erm, float!"))
		end

	end
end

function onGearDelete(gear)

	if (GetGearType(gear) == gtBirdy) or (GetGearType(gear) == gtJetpack) or (GetGearType(gear) == gtRope) or (GetGearType(gear) == gtParachute) then
		specialGear = nil

		if GetGearType(gear) == gtBirdy then
			AddCaption(loc("Bye bye, birdy!"))
		elseif GetGearType(gear) == gtJetpack then
			AddCaption(loc("Goodbye, my flying machine!"))
		elseif GetGearType(gear) == gtRope then
			AddCaption(loc("Ninja-mode, deactivate!"))
		elseif GetGearType(gear) == gtParachute then
			AddCaption(loc("Yikes!"))
		end

	end

end

